%% This makes Figure 6 in in Small et al. "A thinner than present West
% Antarctic Ice Sheet in the southern Weddell Sea Embayment during the
% Holocene"

% It needs a spreadsheet with measurements and a global blank value 
% (Blanks.xlsx). The blank vlaue in the last row.

% read data
blank_data = table2array(readtable('Blanks.xlsx'));

% get means and uncerts (n.b. indexing is static)
sample_mus = blank_data((1:end-1),2);
sample_sigs = blank_data((1:end-1),3);
blank_mu = blank_data(end,2);
blank_sig = blank_data(end,3);

% define X
x = (0:500:(max(sample_mus)+2*max(sample_sigs)));

% Get PDF for blank
y_norm_blank  = normpdf(x,blank_mu,blank_sig);

% create figure
f=figure;

% Plot blank PDF
g1 = area(x,y_norm_blank,'FaceColor','b');

hold on

% now do samples in this loop
for i = 1:length(sample_mus)
    
    y_norm_sample = normpdf(x,sample_mus(i),sample_sigs(i));
    
    % these define upper/lower core samples (again static)
    if i == 1
    gs1 = area(x, y_norm_sample,'FaceColor','r','EdgeAlpha', 0.9);
    elseif i == 5
         gs4 = area(x, y_norm_sample,'FaceColor','r','EdgeAlpha', 0.9);
    elseif i == 9
         gs5 = area(x, y_norm_sample,'FaceColor','r','EdgeAlpha', 0.9);
    else
         gs = area(x, y_norm_sample,'FaceColor','r','EdgeAlpha', 0.3);
    end
end    
 alpha(0.15)
 
 % show 68 and 95 limits as lines
 blank_u68 = blank_mu + blank_sig;
 blank_u95 = blank_mu + (2*blank_sig);
 xline(blank_u68, '--', {'Blank 68%'})
 xline(blank_u95,'_', {'Blank 95%'})
 
 % make legend
 names = {'Blank', 'Upper core samples', 'Lower core samples'};
 legend([g1 gs1 gs], names)
 xlabel('Measured atoms C-14')
 
 print('Blank comparison','-dpng','-r300') % export figure
